using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{

	public enum ZoneType : int {
		SANDBOX = 0,
		TEST = 1,
		REAL = 2,
		DEV = 3

	}

	public enum BannerSize : int {
		NORMAL = 0,
    	MEDIUM = 1,
    	LARGE = 2,
    	FULL = 3
	}

	public enum PositionType : int {
		TOP = 0,
		BOTTOM = 1
	}

	public enum MediationType : int {
		ADMOB = 0,
		APPLOVIN = 1,
		PANGLE = 2,
		UNITY_ADS = 3,
		META = 4,
		LIFTOFF = 5,
		IRONSOURCE = 6
	}

	public class Adiz : MonoBehaviour
	{
		public const string ADIZ_UNITY_PLUGIN_VERSION = "2.1.3";

		public static void InitPlugin() {
			GameObject callbackManager = new GameObject("AdizCallbackManager");
        	callbackManager.AddComponent<AdizCallbackManager>();
        	DontDestroyOnLoad(callbackManager);// Hive Adiz callback
		}

#if UNITY_ANDROID && !UNITY_EDITOR
		
		private static AndroidJavaObject currentActivity = null;
		private static AndroidJavaClass hiveAdizPlugin = new AndroidJavaClass("com.hive.adiz.plugin.AdizUnityPlugin"); 
		
		public static void Initialize(CommonHandlers handler) {
			AdizLogger.d("::Hive Adiz Initialize() call" );
			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");

			hiveAdizPlugin.CallStatic("initialize", currentActivity);

			AdizCallbackManager.sdkInitHandler = handler;
		}

		public static void InitializeForNonGDPR(CommonHandlers handler) {
			AdizLogger.d("::Hive Adiz InitializeForNonGDPR() call" );
			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");

			hiveAdizPlugin.CallStatic("initializeForNonGDPR", currentActivity);

			AdizCallbackManager.sdkInitHandler = handler;
		}

		public static void SetTestMode(bool isOn) {
			hiveAdizPlugin.CallStatic("setTestMode", isOn);
		}

		public static void SetLogEnable(bool isOn) {
			hiveAdizPlugin.CallStatic("setLogEnable", isOn);
		}

		public static void SetZone(int zone) {
			hiveAdizPlugin.CallStatic("setZone", zone);
		}

		public static void SetAppId(string appId) {
			hiveAdizPlugin.CallStatic("setAppId", appId);
		}

		public static string GetVersion() {
			return hiveAdizPlugin.CallStatic<string>("getVersion");
		}

		public static void SetTestDevice(string deviceId) {	
			hiveAdizPlugin.CallStatic("setTestDevice", deviceId);
		}

#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void Adiz_Initialize(string callbackObject, string callbackFunction);

		[DllImport("__Internal")]
		private static extern void Adiz_InitializeForNonGDPR(string callbackObject, string callbackFunction);

		[DllImport("__Internal")]
		private static extern void Adiz_SetTestMode(bool isOn);

		[DllImport("__Internal")]
		private static extern void Adiz_SetZone(int zone);

		[DllImport("__Internal")]
		private static extern void Adiz_SetAppId(string appId);

		[DllImport("__Internal")]
		private static extern void Adiz_SetLogEnable(bool isOn);

		[DllImport("__Internal")]
		private static extern System.IntPtr Adiz_GetVersion();

		[DllImport("__Internal")]
		private static extern void Adiz_SetTestDevice(string identifier);

		public static void Initialize(CommonHandlers handler) {
			AdizLogger.d("::Hive Adiz Initialize() call" );
			AdizCallbackManager.sdkInitHandler = handler;
			Adiz_Initialize("AdizCallbackManager", "onSdkInitialize");
		}

		public static void InitializeForNonGDPR(CommonHandlers handler) {
			AdizLogger.d("::Hive Adiz InitializeForNonGDPR() call" );
			AdizCallbackManager.sdkInitHandler = handler;
			Adiz_InitializeForNonGDPR("AdizCallbackManager", "onSdkInitialize");
		}

		public static void SetTestMode(bool isOn) {
			AdizLogger.d("::Hive Adiz SetTestMode() call" );
			Adiz_SetTestMode(isOn);
		}

		public static void SetLogEnable(bool isOn) {
			AdizLogger.d("::Hive Adiz SetLogEnable() call" );
			Adiz_SetLogEnable(isOn);
		}

		public static void SetZone(int zone) {
			AdizLogger.d("::Hive Adiz SetZone() call" );
			Adiz_SetZone(zone);
		}

		public static void SetAppId(string appId) {
			AdizLogger.d("::Hive Adiz SetAppId() call" );
			Adiz_SetAppId(appId);
		}

		public static string GetVersion() {
			AdizLogger.d("::Hive Adiz GetVersion() call" );
			return Marshal.PtrToStringAnsi(Adiz_GetVersion());
		}

		public static void SetTestDevice(string deviceId) {
			AdizLogger.d("::Hive Adiz SetTestDevice() call");
			Adiz_SetTestDevice(deviceId);
		}
#else

		public static void Initialize(CommonHandlers handler) {
			
		}

		public static void InitializeForNonGDPR(CommonHandlers handler) {
			
		}

		public static void SetTestMode(bool isOn) {
			
		}

		public static void SetLogEnable(bool isOn) {
			
		}

		public static void SetZone(int zone) {
			
		}

		public static void SetAppId(string appId) {
			
		}

		public static string GetVersion() {
			return "";
		}

		public static void SetTestDevice(string deviceId) {
			
		}
		
	#endif
		
	}
}